/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DirContentStatus {
    private File file;
    private File otherFile;
    private Status status;
    private List<DirContentStatus> children;

    public DirContentStatus(File file, Status status) {
        this(file);
        this.status = status;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public DirContentStatus(File file) {
        this.file = file;
        this.status = Status.EQUAL;
        this.children = new ArrayList<DirContentStatus>();
    }

    public File getFile() {
        return this.file;
    }

    public List<DirContentStatus> getChildren() {
        return this.children;
    }

    public File getOtherFile() {
        return this.otherFile;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public DirContentStatus addFileEqual(File file) {
        DirContentStatus dirContentStatus = new DirContentStatus(file, Status.EQUAL);
        this.children.add(dirContentStatus);
        return dirContentStatus;
    }

    public DirContentStatus addFileModified(File file, File file2) {
        DirContentStatus dirContentStatus = new DirContentStatus(file, Status.MODIFIED);
        dirContentStatus.otherFile = file2;
        this.children.add(dirContentStatus);
        return dirContentStatus;
    }

    public DirContentStatus addFileNew(File file) {
        DirContentStatus dirContentStatus = new DirContentStatus(file, Status.NEW);
        this.children.add(dirContentStatus);
        return dirContentStatus;
    }

    public void addAll(DirContentStatus dirContentStatus) {
        this.children.addAll(dirContentStatus.children);
    }

    public void sort() {
        FileComparator fileComparator = new FileComparator();
        Collections.sort(this.children, fileComparator);
    }

    private class FileComparator
    implements Comparator {
        private FileComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            DirContentStatus dirContentStatus = (DirContentStatus)object;
            DirContentStatus dirContentStatus2 = (DirContentStatus)object2;
            n = dirContentStatus.file.isDirectory() != dirContentStatus2.file.isDirectory() ? (dirContentStatus.file.isDirectory() ? -1 : 1) : dirContentStatus.file.getName().compareTo(dirContentStatus2.file.getName());
            return n;
        }
    }

    public static enum Status {
        NEW,
        MODIFIED,
        EQUAL;

    }
}

