/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.hibernate;

import com.qarks.util.ReflectionHelper;
import com.qarks.util.hibernate.SessionWrapper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class HibernateInterceptor
implements InvocationHandler {
    private Object intercepted;
    private static SessionWrapper currentSessions = new SessionWrapper();
    private SessionFactory factory;

    public HibernateInterceptor(Object object, SessionFactory sessionFactory) {
        this.intercepted = object;
        this.factory = sessionFactory;
    }

    public static <T> T getProxy(Class<T> clazz, Object object, SessionFactory sessionFactory) {
        Object object2 = null;
        HibernateInterceptor hibernateInterceptor = new HibernateInterceptor(object, sessionFactory);
        ClassLoader classLoader = hibernateInterceptor.getClass().getClassLoader();
        object2 = Proxy.newProxyInstance(classLoader, new Class[]{clazz}, (InvocationHandler)hibernateInterceptor);
        return (T)object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        boolean bl;
        Object object2;
        Object object3 = null;
        Class[] classArray = method.getParameterTypes();
        Method method2 = ReflectionHelper.getMethod(this.intercepted.getClass(), method.getName(), classArray);
        List<Field> list = ReflectionHelper.getAllFields(this.intercepted.getClass());
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (int i = 0; i < list.size(); ++i) {
            Field field = list.get(i);
            object2 = field.getType().getName();
            if (!((String)object2).equals("org.hibernate.Session")) continue;
            arrayList.add(field);
            field.setAccessible(true);
            field.set(this.intercepted, currentSessions);
        }
        Session session = currentSessions.getSession();
        boolean bl2 = bl = session == null;
        if (bl) {
            object2 = this.factory.getCurrentSession();
            currentSessions.putSession((Session)object2);
            try {
                object2.beginTransaction();
                object3 = method2.invoke(this.intercepted, objectArray);
                if (!object2.isOpen()) return object3;
                object2.getTransaction().commit();
                return object3;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable.printStackTrace();
                object2.getTransaction().rollback();
                if (!(throwable instanceof InvocationTargetException)) throw throwable2;
                Throwable throwable3 = ((InvocationTargetException)throwable).getTargetException();
                if (!(throwable3 instanceof Serializable)) throw throwable2;
                throwable2 = throwable3;
                throw throwable2;
            }
            finally {
                currentSessions.removeSession();
                if (object2.isOpen()) {
                    object2.close();
                }
            }
        } else {
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                Field field = (Field)object2.next();
                field.set(this.intercepted, currentSessions);
            }
            return method2.invoke(this.intercepted, objectArray);
        }
    }
}

