/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import com.qarks.util.files.diff.FileLine;
import com.qarks.util.files.diff.ParsedFile;
import com.qarks.util.files.diff.ui.LineCellRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JPanel;

public class FileOverview
extends JPanel {
    private ParsedFile parsedFile = null;

    public void setParsedFile(ParsedFile parsedFile) {
        this.parsedFile = parsedFile;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (this.parsedFile != null) {
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = fontMetrics.getHeight();
            FileLine[] fileLineArray = this.parsedFile.getLines();
            if (fileLineArray != null && fileLineArray.length > 0) {
                int n2 = dimension.width;
                float f = dimension.height;
                float f2 = fileLineArray.length;
                int n3 = (int)(f / f2);
                int n4 = Math.max(n3, 3);
                n4 = Math.min(n4, n);
                for (int i = 0; i < fileLineArray.length; ++i) {
                    FileLine fileLine = fileLineArray[i];
                    boolean bl = false;
                    int n5 = 0;
                    Color color = Color.white;
                    n5 = n4 == n ? i * n : (int)((float)dimension.height - (float)(fileLineArray.length - i) * f / f2);
                    if (fileLine.getIndex() > -1) {
                        if (fileLine.getStatus() == -1) {
                            color = LineCellRenderer.INSERTED_COLOR;
                            bl = true;
                        } else if (fileLine.getStatus() == 2) {
                            color = LineCellRenderer.MOVED_COLOR;
                            bl = true;
                        } else if (fileLine.getStatus() == 3) {
                            color = LineCellRenderer.MODIFIED_COLOR;
                            bl = true;
                        } else if (fileLine.getStatus() == 5) {
                            color = LineCellRenderer.DELETED_COLOR;
                            bl = true;
                        } else if (fileLine.getStatus() == 4) {
                            color = LineCellRenderer.INSERTED_COLOR;
                            bl = true;
                        }
                    } else if (fileLine.getStatus() == 4) {
                        color = LineCellRenderer.DELETED_COLOR;
                        bl = true;
                    }
                    if (!bl) continue;
                    graphics.setColor(color);
                    for (int j = 0; j < dimension.height && j <= n4; ++j) {
                        graphics.drawLine(0, n5 + j, n2, n5 + j);
                    }
                }
            }
        } else {
            super.paintComponent(graphics);
        }
    }
}

