% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc07CTDC.R
\name{extractCTDC}
\alias{extractCTDC}
\title{CTD Descriptors - Composition}
\usage{
extractCTDC(x)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}
}
\value{
A length 21 named vector
}
\description{
CTD Descriptors - Composition
}
\details{
This function calculates the Composition descriptor of the
CTD descriptors (Dim: 21).
}
\note{
For this descriptor type, users need to intelligently evaluate
the underlying details of the descriptors provided, instead of using
this function with their data blindly. It would be wise to use some
negative and positive control comparisons where relevant to help guide
interpretation of the results.
}
\examples{
x = readFASTA(system.file('protseq/P00750.fasta', package = 'protr'))[[1]]
extractCTDC(x)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\references{
Inna Dubchak, Ilya Muchink, Stephen R. Holbrook and Sung-Hou Kim.
Prediction of protein folding class using global description of
amino acid sequence. \emph{Proceedings of the National Academy of Sciences}.
USA, 1995, 92, 8700-8704.

Inna Dubchak, Ilya Muchink, Christopher Mayor, Igor Dralyuk and Sung-Hou Kim.
Recognition of a Protein Fold in the Context of the SCOP classification.
\emph{Proteins: Structure, Function and Genetics}, 1999, 35, 401-407.
}
\seealso{
See \code{\link{extractCTDT}} and \code{\link{extractCTDD}}
         for Transition and Distribution of the CTD descriptors.
}
\keyword{CTD}
\keyword{Composition}
\keyword{extract}

