% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportionality.R
\name{proportionality}
\alias{perb}
\alias{phis}
\alias{phit}
\alias{proportionality}
\title{Calculate Proportionality}
\usage{
phit(counts, symmetrize = TRUE)

perb(counts, ivar = 0, select)

phis(counts, ivar = 0, select)
}
\arguments{
\item{counts}{A data.frame or matrix. A "count matrix" with
subjects as rows and features as columns.}

\item{symmetrize}{A logical. If \code{TRUE}, forces symmetry
by reflecting the "lower left triangle".}

\item{ivar}{A numeric scalar. Specificies a reference feature
for additive log-ratio transformation. The argument will also
accept a feature name instead of the index position.}

\item{select}{Subsets via \code{object@counts[, select]}.
Optional. Use this argument to subset the proportionality
matrix without altering the final result.}
}
\value{
Returns a \code{propr} object.
}
\description{
Let D represent any number of features measured across N biological replicates
	exposed to a binary or continuous event E. For example, E could represent case-control
	status, treatment status, treatment dose, or time. This function converts a "count matrix"
	with N rows and D columns into a proportionality matrix of D rows and D columns.

For phi, the result of \code{phit}, one can think of the resultant matrix as
	analogous to a distance matrix, except that it has no symmetry unless forced.
	For phs, the result of \code{phis}, one can think of the resultant matrix as
	either a naturally symmetric variant of phi or a monotonic variant of rho.
	For rho, the result of \code{perb}, one can think of the resultant matrix as
	analogous to a correlation matrix.

\code{perb} and \code{phis} use a centered log-ratio transformation by default,
 but will use an additive log-ratio transformation instead if a non-zero
 \code{ivar} is provided. When using an additive log-ratio transformation,
 this function will return \code{rho = 0} for the column and row in the
 \code{@matrix} slot that would contain the reference feature.

Log-ratio transformation, by its nature, fails if the input data contain
 any zero values. To avoid an error in this case, these functions automatically
 replace all zero values with 1. Note, however, that the topic of
 zero replacement is controversial. Proceed carefully when analyzing data
 that contain zero values.
}
\examples{
library(propr)
data(mail)
phi <- phit(mail)
phs <- phis(mail)
rho <- perb(mail)
}

