% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/501.Error-Failure_LimitBased_BASE_All.R
\name{errBA}
\alias{errBA}
\title{Calculates error, long term power and pass/fail criteria for Bayesian method}
\usage{
errBA(n, alp, phi, f, a, b)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{phi}{- Null hypothesis value}

\item{f}{- Failure criterion}

\item{a}{- Beta parameters for hypo "p"}

\item{b}{- Beta parameters for hypo "p"}
}
\value{
A dataframe with
 \item{delalp}{ Delta-alpha is the increase of the nominal error with respect to real error}
 \item{theta}{ Long term power of the test}
 \item{Fail_Pass}{Fail/pass based on the input f criterion}
 \item{method}{Name of method - Quantile or HPD}
}
\description{
Calculates error, long term power and pass/fail criteria for Bayesian method
}
\details{
Evaluation of Bayesian Highest Probability Density
(HPD) and two tailed intervals using error due to the difference of achieved and
nominal level of significance for the \eqn{n + 1} intervals
for the Beta - Binomial conjugate prior model for the probability of success \code{p}
}
\examples{
n=20; alp=0.05; phi=0.05; f=-2;a=0.5;b=0.5
errBA(n,alp,phi,f,a,b)
}
\references{
[1] 2014 Martin Andres, A. and Alvarez Hernandez, M.
Two-tailed asymptotic inferences for a proportion.
Journal of Applied Statistics, 41, 7, 1516-1529
}
\seealso{
Other Error for base methods: \code{\link{PloterrAS}},
  \code{\link{PloterrAll}}, \code{\link{PloterrBA}},
  \code{\link{PloterrEX}}, \code{\link{PloterrLR}},
  \code{\link{PloterrLT}}, \code{\link{PloterrSC}},
  \code{\link{PloterrTW}}, \code{\link{PloterrWD}},
  \code{\link{errAS}}, \code{\link{errAll}},
  \code{\link{errEX}}, \code{\link{errLR}},
  \code{\link{errLT}}, \code{\link{errSC}},
  \code{\link{errTW}}, \code{\link{errWD}}
}
