% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_weightedStudySpecification.R
\name{c,WeightedStudySpecification-method}
\alias{c,WeightedStudySpecification-method}
\title{Concatenate weights}
\usage{
\S4method{c}{WeightedStudySpecification}(x, ..., warn_dichotomy_not_equal = FALSE)
}
\arguments{
\item{x, }{.. a \code{WeightedStudySpecification} object, typically created
from \code{\link[=ate]{ate()}} or \code{\link[=ett]{ett()}}}

\item{...}{any number of additional \code{WeightedStudySpecification}
objects with equivalent \code{StudySpecification} to \code{x} and
eachother}

\item{warn_dichotomy_not_equal}{if \code{FALSE} (default),
\code{WeightedStudySpecification}s are considered equivalent even if their
\code{dichotomy} differs. If \code{TRUE}, a warning is produced.}
}
\value{
A numeric \code{vector} with the weights concatenated in the input
order.
}
\description{
Given several variations of weights generated from a single
\code{StudySpecification}, combine into a single weight.
}
\details{
Concatenating \code{WeightedStudySpecification} objects with \code{\link[=c]{c()}}
requires both individual \code{WeightedStudySpecification} objects to come
from the same \code{StudySpecification} and have the same target (e.g all
created with \code{\link[=ate]{ate()}} or all created with \code{\link[=ett]{ett()}}, no mixing-and-matching).
All arguments to \code{\link[=c]{c()}} must be \code{WeightedStudySpecification}.

\code{WeightedStudySpecification} objects may be concatenated together
even without having the same \code{@dichotomy} slot. This procedure only
prompts a warning for differing dichotomies if the argument
\code{warn_dichotomy_not_equal} is set to \code{TRUE}.
}
\examples{
data(simdata)
spec <- rct_spec(z ~ unit_of_assignment(uoa1, uoa2), data = simdata)
w1 <- ate(spec, data = simdata[1:30,])
w2 <- ate(spec, data = simdata[31:40,])
w3 <- ate(spec, data = simdata[41:50,])
c_w <- c(w1, w2, w3)
c(length(w1), length(w2), length(w3), length(c_w))

spec <- rct_spec(dose ~ unit_of_assignment(uoa1, uoa2), data = simdata)
w1 <- ate(spec, data = simdata[1:10, ], dichotomy = dose >= 300 ~ .)
w2 <- ate(spec, data = simdata[11:30, ], dichotomy = dose >= 200 ~ .)
w3 <- ate(spec, data = simdata[31:50, ], dichotomy = dose >= 100 ~ .)
c_w <- c(w1, w2, w3)
}
