% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promote.R
\name{promote.predict_raw}
\alias{promote.predict_raw}
\title{Calls promote's REST API and returns a JSON document containing both the prediction
and associated metadata.}
\usage{
promote.predict_raw(model_name, data, model_owner, raw_input = FALSE,
  silent = TRUE)
}
\arguments{
\item{model_name}{the name of the model you want to call}

\item{data}{input data for the model}

\item{model_owner}{the owner of the model [optional]}

\item{raw_input}{when true, incoming data will NOT be coerced into data.frame}

\item{silent}{should output of url to console (via \code{promote.post})
be silenced? Default is \code{FALSE}.}
}
\description{
Calls promote's REST API and returns a JSON document containing both the prediction
and associated metadata.
}
\examples{
promote.config <- c(
 username = "your username",
 apikey = "your apikey",
 env="http://ip_of_alteryx_promote.com"
)
\dontrun{
promote.predict_raw("irisModel", iris)
}
}
