\name{bate}
\alias{bate}
\alias{print.memix}
\alias{plot.memix}
\alias{ResponderAnalysis}
\alias{pratio}

\title{Bayesian Hierarchical Model for RPO data with repeated measures}
\usage{
bate(x0,x1,group,z,x.range,...)
ResponderAnalysis(x,mcid,type="absolute",conf.level=0.95,show=TRUE)
}
\arguments{
\item{x0,x1}{Numeric vector/matrix of observations at T0 (baseline) and
  T1 (end point) of a study.}
\item{z}{covariates}
\item{group}{group assignments. Current version support one or two
  groups only}
\item{x.range}{range of data 'x0' and 'x1'}
\item{x}{An R object generated by \code{memixed}}
\item{mcid}{A threshold to define 'responder'}
\item{type}{The type of responder analysis: absolute or relative changes}
\item{conf.level}{Confidence level of the credible interval}
\item{show}{control whether results should be displayed}
\item{...}{Parameters ("adapt_delta","stepsize","max_treedepth") to improve model
  fitting/convergence.}
}
\value{
\itemize{
\item `xfit`: fitted results using stan.
\item `mu.t0`: baseline mean.
\item `sig.t0`: baseline SD.
\item `sig.me`: SD of measurement errors.
\item `mu.active`: mean effect size of active treatment.
\item `sig.active`: sd of effect size of active treatment.
\item `mu.sham`: mean effect size of sham treatment.
\item `sig.sham`: sd of effect size of sham treatment.
}
}
\description{
A Bayesian hierachical model to denoise PRO data using repeated measures.
}
\examples{
\donttest{
data(n100x3)
out1  <-  bate(x0=ex100x3$w0,x1=ex100x3$w1,group=ex100x3$group)
out1
ResponderAnalysis(out1,mcid=1,type="abs")
out2  <-  bate(x0=ex100x3$w0,x1=ex100x3$w1,group=ex100x3$group,
    control = list(adapt_delta = 0.8,
               stepsize = 5,
               max_treedepth = 10)
)
out2
ResponderAnalysis(out2,mcid=1,type="abs")
out <- out2
ResponderAnalysis(out,mcid=0.5,type="abs")
ResponderAnalysis(out,mcid=1,type="abs")
ResponderAnalysis(out,mcid=1.5,type="abs")
ResponderAnalysis(out,mcid=0.3,type="relative")
ResponderAnalysis(out,mcid=0.2,type="relative")
ResponderAnalysis(out,mcid=0.1,type="relative")
}
}