% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_varsel.R
\name{run_cvfun}
\alias{run_cvfun}
\alias{run_cvfun.default}
\alias{run_cvfun.refmodel}
\title{Create \code{cvfits} from \code{cvfun}}
\usage{
run_cvfun(object, ...)

\method{run_cvfun}{default}(object, ...)

\method{run_cvfun}{refmodel}(
  object,
  K = if (!inherits(object, "datafit")) 5 else 10,
  seed = NA,
  ...
)
}
\arguments{
\item{object}{An object of class \code{refmodel} (returned by \code{\link[=get_refmodel]{get_refmodel()}} or
\code{\link[=init_refmodel]{init_refmodel()}}) or an object that can be passed to argument \code{object} of
\code{\link[=get_refmodel]{get_refmodel()}}.}

\item{...}{For \code{\link[=run_cvfun.default]{run_cvfun.default()}}: Arguments passed to \code{\link[=get_refmodel]{get_refmodel()}}.
For \code{\link[=run_cvfun.refmodel]{run_cvfun.refmodel()}}: Currently ignored.}

\item{K}{Number of folds. Must be at least 2 and not exceed the number of
observations.}

\item{seed}{Pseudorandom number generation (PRNG) seed by which the same
results can be obtained again if needed. Passed to argument \code{seed} of
\code{\link[=set.seed]{set.seed()}}, but can also be \code{NA} to not call \code{\link[=set.seed]{set.seed()}} at all. If not
\code{NA}, then the PRNG state is reset (to the state before calling
\code{\link[=run_cvfun]{run_cvfun()}}) upon exiting \code{\link[=run_cvfun]{run_cvfun()}}.}
}
\value{
An object that can be used as input for \code{\link[=cv_varsel.refmodel]{cv_varsel.refmodel()}}'s
argument \code{cvfits}.
}
\description{
A helper function that can be used to create input for
\code{\link[=cv_varsel.refmodel]{cv_varsel.refmodel()}}'s argument \code{cvfits} by running first \code{\link[=cv_folds]{cv_folds()}} and
then the reference model object's \code{cvfun} (see \code{\link[=init_refmodel]{init_refmodel()}}). This is
helpful if \eqn{K}-fold CV is run multiple times based on the same \eqn{K}
reference model refits.
}
\examples{
\dontshow{if (requireNamespace("rstanarm", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Data:
dat_gauss <- data.frame(y = df_gaussian$y, df_gaussian$x)

# The "stanreg" fit which will be used as the reference model (with small
# values for `chains` and `iter`, but only for technical reasons in this
# example; this is not recommended in general):
fit <- rstanarm::stan_glm(
  y ~ X1 + X2 + X3 + X4 + X5, family = gaussian(), data = dat_gauss,
  QR = TRUE, chains = 2, iter = 500, refresh = 0, seed = 9876
)

# Define the reference model object explicitly:
ref <- get_refmodel(fit)

# Run the reference model object's `cvfun` (with a small value for `K`, but
# only for the sake of speed in this example; this is not recommended in
# general):
cvfits <- run_cvfun(ref, K = 2, seed = 184)

# Run cv_varsel() (with L1 search and small values for `nterms_max` and
# `nclusters_pred`, but only for the sake of speed in this example; this is
# not recommended in general) and use `cvfits` there:
cvvs_L1 <- cv_varsel(fit, method = "L1", cv_method = "kfold",
                     cvfits = cvfits, nterms_max = 3, nclusters_pred = 10,
                     seed = 5555)
# Now see, for example, `?print.vsel`, `?plot.vsel`, `?suggest_size.vsel`,
# and `?ranking` for possible post-processing functions.

# The purpose of run_cvfun() is to create an object that can be used in
# multiple cv_varsel() calls, e.g., to check the sensitivity to the search
# method (L1 or forward):
cvvs_fw <- cv_varsel(fit, method = "forward", cv_method = "kfold",
                     cvfits = cvfits, nterms_max = 3, nclusters = 5,
                     nclusters_pred = 10, seed = 5555)
\dontshow{\}) # examplesIf}
}
