% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refmodel.R
\name{predict.refmodel}
\alias{predict.refmodel}
\title{Predictions or log predictive densities from a reference model}
\usage{
\method{predict}{refmodel}(
  object,
  newdata = NULL,
  ynew = NULL,
  offsetnew = NULL,
  weightsnew = NULL,
  type = "response",
  ...
)
}
\arguments{
\item{object}{An object of class \code{refmodel} (returned by \code{\link[=get_refmodel]{get_refmodel()}} or
\code{\link[=init_refmodel]{init_refmodel()}}).}

\item{newdata}{Passed to argument \code{newdata} of the reference model's
\code{extract_model_data} function (see \code{\link[=init_refmodel]{init_refmodel()}}). Provides the
predictor (and possibly also the response) data for the new (or old)
observations. May also be \code{NULL} (see argument \code{extract_model_data} of
\code{\link[=init_refmodel]{init_refmodel()}}). If not \code{NULL}, any \code{NA}s will trigger an error.}

\item{ynew}{If not \code{NULL}, then this needs to be a vector of new (or old)
response values. See section "Value" below.}

\item{offsetnew}{Passed to argument \code{orhs} of the reference model's
\code{extract_model_data} function (see \code{\link[=init_refmodel]{init_refmodel()}}). Used to get the
offsets for the new (or old) observations.}

\item{weightsnew}{Passed to argument \code{wrhs} of the reference model's
\code{extract_model_data} function (see \code{\link[=init_refmodel]{init_refmodel()}}). Used to get the
weights for the new (or old) observations.}

\item{type}{Only relevant if \code{is.null(ynew)}. The scale on which the
predictions are returned, either \code{"link"} or \code{"response"} (see
\code{\link[=predict.glm]{predict.glm()}} but note that \code{\link[=predict.refmodel]{predict.refmodel()}} does not adhere to the
typical \R convention of a default prediction on link scale). For both
scales, the predictions are averaged across the posterior draws.}

\item{...}{Currently ignored.}
}
\value{
Either a vector of predictions (with the scale depending on argument
\code{type}) or, if \code{!is.null(ynew)}, a vector of log predictive densities
evaluated at \code{ynew}.
}
\description{
This is the \code{\link[=predict]{predict()}} method for \code{refmodel} objects (returned by
\code{\link[=get_refmodel]{get_refmodel()}} or \code{\link[=init_refmodel]{init_refmodel()}}). It offers three types of output which
are all based on the reference model and new (or old) observations: Either
the linear predictor on link scale, the linear predictor transformed to
response scale, or the log predictive density.
}
\details{
Argument \code{weightsnew} is only relevant if \code{!is.null(ynew)}.
}
