% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/critical_path.R
\name{critical_path}
\alias{critical_path}
\title{Generate the critical path for a collection of related tasks}
\usage{
critical_path(df, gantt = F, network = F, start_date = Sys.Date())
}
\arguments{
\item{df}{A data frame of tasks with columns ID, name, duration, id's of predecessrs (as a comma separated string)
in that order. Name of columns does not matter, only order. Type 'taskdata1' into the console for an example of valid data.}

\item{gantt}{Boolean that specifies whether or not to produce a gantt chart of the results.}

\item{network}{Boolean that specifies whether or not to produce a network diagram of the results}

\item{start_date}{Starting date for the project. Defaults to the current date.}
}
\value{
A list of results.

\itemize{
\item \strong{critical_path} The id's of the critical path.
\item \strong{results} A data frame representation of the results that can be passed to the 'gantt' function.
\item \strong{gantt} Gantt chart if 'gantt' argument is true.
\item \strong{duration} The duration of the project in days.
\item \strong{end_date} The end date of the project.
\item \strong{network} Network diagram if 'network' argument true.
}
}
\description{
Generate the critical path for a collection of related tasks
}
\examples{
# Use provided sample data
df <- taskdata1

res <- critical_path(df)

}
