% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_projections.R
\name{build_projections}
\alias{build_projections}
\title{Constructor for projections objects}
\usage{
build_projections(x, dates = NULL, cumulative = FALSE, order_dates = TRUE)
}
\arguments{
\item{x}{A \code{matrix} of simulated incidence stored as integers, where
rows correspond to dates and columns to simulations.}

\item{dates}{A vector of dates containing one value per row in \code{x};
acceptable formats are: \code{integer}, \code{Date}, and \code{POSIXct}; if
NULL, the time steps will be counted, with the first dates corresponding to
0.}

\item{cumulative}{A logical indicating if data represent cumulative
incidence; defaults to \code{FALSE}.}

\item{order_dates}{A logical indicating whether the dates should be ordered,
from the oldest to the most recent one; `TRUE` by default.}
}
\description{
This function builds a valid \code{projections} object from some input
simulations and dates.
}
\seealso{
the \code{\link{project}} function to generate the 'projections'
  objects.
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
