<!--
%\VignetteIndexEntry{progressr: Debug}
%\VignetteAuthor{Henrik Bengtsson}
%\VignetteKeyword{R}
%\VignetteKeyword{package}
%\VignetteKeyword{vignette}
%\VignetteKeyword{debugging}
%\VignetteEngine{progressr::selfonly}
-->

Progress updates generated by **[progressr]** are formally R conditions
of class `progression` that are signaled and handled by R's condition
framework. Sometimes these `progression` conditions are not signaled,
or transmitted, as expected. To troubleshoot such problems, we can use
the built-in "debug" handler. For example,

```r
> library(progressr)
> handlers("debug")
> handlers(global = TRUE)
> 
> y <- slow_sum(1:3)
[21:17:01.786] (0.000s => +0.015s) initiate: 0/3 (+0) '' {clear=TRUE, enabled=TRUE, status=}
[21:17:01.975] (0.189s => +0.179s) update: 0/3 (+0) '' {clear=TRUE, enabled=TRUE, status=}
[21:17:02.378] (0.593s => +0.002s) update: 0/3 (+0) '' {clear=TRUE, enabled=TRUE, status=}
[21:17:02.581] (0.796s => +0.002s) update: 1/3 (+1) 'P: Adding 1' {clear=TRUE, enabled=TRUE, status=}
M: Added value 1
[21:17:02.788] (1.002s => +0.004s) update: 1/3 (+0) 'P: Adding 1' {clear=TRUE, enabled=TRUE, status=}
[21:17:02.990] (1.205s => +0.001s) update: 1/3 (+0) 'P: Adding 1' {clear=TRUE, enabled=TRUE, status=}
[21:17:03.394] (1.608s => +0.002s) update: 1/3 (+0) 'P: Adding 1' {clear=TRUE, enabled=TRUE, status=}
[21:17:03.597] (1.812s => +0.002s) update: 2/3 (+1) 'P: Adding 2' {clear=TRUE, enabled=TRUE, status=}
M: Added value 2
[21:17:03.807] (2.021s => +0.007s) update: 2/3 (+0) 'P: Adding 2' {clear=TRUE, enabled=TRUE, status=}
[21:17:04.010] (2.224s => +0.001s) update: 2/3 (+0) 'P: Adding 2' {clear=TRUE, enabled=TRUE, status=}
[21:17:04.412] (2.627s => +0.001s) update: 2/3 (+0) 'P: Adding 2' {clear=TRUE, enabled=TRUE, status=}
[21:17:04.616] (2.830s => +0.002s) update: 3/3 (+1) 'P: Adding 3' {clear=TRUE, enabled=TRUE, status=}
[21:17:04.618] (2.832s => +0.004s) update: 3/3 (+0) 'P: Adding 3' {clear=TRUE, enabled=TRUE, status=}
M: Added value 3
> 
```

[progressr]: https://progressr.futureverse.org
