% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphicsFuns.R
\name{getChangePoints}
\alias{getChangePoints}
\title{Coordinate profiles crossing points}
\usage{
getChangePoints(threshold, Design = NULL, allRes)
}
\arguments{
\item{threshold}{if not null plots the level}

\item{Design}{a d dimensional design corresponding to the points}

\item{allRes}{list containing the list \code{res} which contains the computed minima and maxima. The object returned by the function \code{getAllMaxMin}.}
}
\value{
returns a list containing two lists with d components where
\itemize{
\item{alwaysEx:} each component is a numerical vector indicating the points \eqn{x_i} where \eqn{inf_{x^{-i}}f(x) >} \code{threshold};
\item{neverEx:} each component is a numerical vector indicating the points \eqn{x_i} where \eqn{sup_{x^{-i}}f(x) <} \code{threshold}.
}
}
\description{
Obtain the points where the coordinate profile extrema functions cross the threshold
}
\author{
Dario Azzimonti
}
