\name{predict.prodlim}
\alias{predict.prodlim}
\alias{predictSurv}
\alias{predictCuminc}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Predicting event probabilities from product limit estimates}
\description{
  Evaluation of estimated survival or event probabilities at given
  times and covariate constellations.
}

\usage{
\method{predict}{prodlim}(object,
		times,
		newdata,
		level.chaos=1,
		type=c("surv","cuminc","list"),
		mode="list",
		bytime=FALSE,
		cause=1,
		...)
}

%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{
    A fitted object of class "prodlim".
  }

  \item{times}{
    Vector of times at which to return the estimated probabilities.
  }

  \item{newdata}{
    A data frame with the same variable names as those that
    appear on the right hand side of the 'prodlim' formula.
    If there are covariates this argument is required.
  }

  \item{level.chaos}{
    Integer specifying the sorting of the output:
    `0' sort by time and newdata;
    `1' only by time;
    `2' no sorting at all
  }

  \item{type}{
   Choice between "surv","cuminc","list":

   "surv": predict survival probabilities
           only survival models

   "cuminc": predict cumulative incidences 
           only competing risk models

   "list": find the indices corresponding to
   times and newdata. See value.

   Defaults to "surv" for two-state models and to "cuminc" for competing risk models.
  }

\item{mode}{
Only for \code{type=="surv"} and \code{type=="cuminc"}.
Can either be "list" or "matrix". For "matrix"
the predicted probabilities will be returned in matrix form.
}

\item{bytime}{
 Logical. If TRUE and \code{mode=="matrix"}
the matrix with predicted probabilities will
have a column for each time and a row for each
newdata. Only when \code{object$covariate.type>1}
and more than one time is given.
}
\item{cause}{
  The cause for predicting the cause-specific cumulative incidence
  function in competing risk models.
}

\item{\dots}{
Only for compatibility reasons.
} 
}
\details{
  Predicted (survival) probabilities are returned that can be plotted, summarized
  and used for inverse of probability of censoring weighting. 
} \value{

  \code{type=="surv"}: A list or a matrix with survival
probabilities for all times and all newdata.

  \code{type=="cuminc"}: A list or a matrix with cumulative
incidences for all times and all newdata.

  \code{type=="list"}: A list with the following components:

  \item{times}{The argument \code{times} carried forward}

  \item{predictors}{
   The relevant part of the argument \code{newdata}.
 }

  \item{indices}{
A list with the following components:
\item{time}{Where to find values corresponding to the requested times}
\item{strata}{Where to find values corresponding to the
values of the variables in newdata.
Together time and strata show where to find the predicted probabilities.}
}

  \item{dimensions}{
a list with the following components:
\item{time}{The length of \code{times} }
\item{strata}{
The number of rows in \code{newdata}
}}

\item{names.strata}{Labels for the covariate values.}
}
% \references{ ~put references to the literature/web site here ~ }
\author{Thomas Gerds <tag@biostat.ku.dk>}

% \note{ ~~further notes~~ 

%   ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{\code{\link{predictSurvIndividual}}}

 \examples{
\dontrun{
library(survival)
data(pbc)
fit <- prodlim(Hist(time,status)~1,data=pbc)

## predict the survival probs at selected times 
predict(fit,times=c(10,100,1000))

## works also outside the usual range of the Kaplan-Meier
predict(fit,times=c(-1,0,10,100,1000,10000))

## newdata is required if there are strata
## or neighborhoods (ie overlapping strata)
mfit <- prodlim(Hist(time,status)~edema+age,data=pbc)
predict(mfit,times=c(-1,0,10,100,1000,10000),newdata=pbc[18:21,])

## this can be requested in matrix form
predict(mfit,times=c(-1,0,10,100,1000,10000),newdata=pbc[18:21,],mode="matrix")

## and even transposed
predict(mfit,times=c(-1,0,10,100,1000,10000),newdata=pbc[18:21,],mode="matrix",bytime=TRUE)
}
}
\keyword{survival}% at least one, from doc/KEYWORDS
