% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_names.R
\name{make_names}
\alias{make_names}
\title{Create procedural names.}
\usage{
make_names(corpus, n, n_words, retry, sep = "_", case)
}
\arguments{
\item{corpus}{A vector of strings to build names from.}

\item{n}{The number of random names to be generated.}

\item{n_words}{The number of words to combine into a name.}

\item{retry}{If `TRUE`, a random integer between 1 and 10 is appended to each
generated name.}

\item{sep}{A character string to separate the terms. Not `NA_character_`.}

\item{case}{One of either "lower", "upper", or "title". The capitalization to
use for each word.}
}
\value{
A character vector of length `n` of random names, each composed of
`n_word` terms capitalized according to `case` separated by `sep`. Note that
names are not guaranteed to be unique.
}
\description{
Create procedural names.
}
