% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anonymize_id.R
\name{anonymize_id}
\alias{anonymize_id}
\title{Anonymize Patient Identifiers}
\usage{
anonymize_id(x, prefix = "ID", seed = NULL, use_uuid = TRUE)
}
\arguments{
\item{x}{A vector of identifiers to anonymize (character, numeric, or factor)}

\item{prefix}{A character string to prefix anonymized IDs (default: "ID")}

\item{seed}{An optional seed for reproducible anonymization}

\item{use_uuid}{Logical, if TRUE uses short UUIDs instead of sequential IDs
(default: TRUE).}
}
\value{
A character vector of anonymized identifiers
}
\description{
Replaces patient identifiers with anonymized versions while maintaining
referential integrity (same IDs get the same anonymized value).
}
\examples{
ids <- c("P001", "P002", "P003", "P001")
anonymize_id(ids)
anonymize_id(ids, prefix = "PAT", seed = 123)
anonymize_id(ids, use_uuid = FALSE, seed = 123)  # Use sequential IDs

}
