% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization_problem.R
\name{optimization_problem}
\alias{optimization_problem}
\title{Optimization problem}
\usage{
optimization_problem(x = NULL)
}
\arguments{
\item{x}{A \code{NULL} or \code{list} object. See Details for more information.
Defaults to \code{NULL}.}
}
\value{
An \linkS4class{OptimizationProblem} object.
}
\description{
Create a new optimization problem.
}
\details{
The argument to \code{x} can be a \code{NULL} or a \code{list}. If \code{x} is a \code{NULL},
then an empty optimization problem is created. Alternately, if a \code{x} is
a \code{list} then a fully formulated optimization problem is created.
Specifically, the \code{list} should contain the following elements.

\describe{

\item{modelsense}{\code{character} model sense.}

\item{number_of_features}{\code{integer} number of features in problem.}

\item{number_of_planning_units}{\code{integer} number of planning units.}

\item{A_i}{\code{integer} row indices for problem matrix.}

\item{A_j}{\code{integer} column indices for problem matrix.}

\item{A_x}{\code{numeric} values for problem matrix.}

\item{obj}{\code{numeric} objective function values.}

\item{lb}{\code{numeric} lower bound for decision values.}

\item{ub}{\code{numeric} upper bound for decision values.}

\item{rhs}{\code{numeric} right-hand side values.}

\item{sense}{\code{numeric} constraint senses.}

\item{vtype}{\code{character} variable types. These are used to specify
that the decision variables are binary (\code{"B"}) or continuous
(\code{"C"}).}

\item{row_ids}{\code{character} identifiers for the rows in the problem
matrix.}

\item{col_ids}{\code{character} identifiers for the columns in the problem
matrix.}

}
}
\examples{
# create new empty object
x1 <- optimization_problem()

# print new empty object
print(x1)

# create list with optimization problem
l <- list(
  modelsense = "min",
  number_of_features = 2,
  number_of_planning_units = 3,
  number_of_zones = 1,
  A_i = c(0L, 1L, 0L, 1L, 0L, 1L),
  A_j = c(0L, 0L, 1L, 1L, 2L, 2L),
  A_x = c(2, 10, 1, 10, 1, 10),
  obj = c(1, 2, 2),
  lb = c(0, 1, 0),
  ub = c(0, 1, 1),
  rhs = c(2, 10),
  compressed_formulation = TRUE,
  sense = c(">=", ">="),
  vtype = c("B", "B", "B"),
  row_ids = c("spp_target", "spp_target"),
  col_ids = c("pu", "pu", "pu")
)

# create fully formulated object based on lists
x2 <- optimization_problem(l)

# print fully formulated object
print(x2)
}
\seealso{
\link{OptimizationProblem-methods}.
}
