% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_of_zones.R
\name{number_of_zones}
\alias{number_of_zones}
\alias{number_of_zones,ConservationProblem-method}
\alias{number_of_zones,OptimizationProblem-method}
\alias{number_of_zones,ZonesRaster-method}
\alias{number_of_zones,ZonesCharacter-method}
\title{Number of zones}
\usage{
number_of_zones(x)

\S4method{number_of_zones}{ConservationProblem}(x)

\S4method{number_of_zones}{OptimizationProblem}(x)

\S4method{number_of_zones}{ZonesRaster}(x)

\S4method{number_of_zones}{ZonesCharacter}(x)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} (i.e. \code{\linkS4class{ConservationProblem}}),
\code{\linkS4class{OptimizationProblem}}, or \code{\link[=Zones]{Zones()}} object.}
}
\value{
\code{integer} number of zones.
}
\description{
Extract the number of zones in an object.
}
\examples{
# load data
data(sim_pu_zones_stack, sim_features_zones)

# print number of zones in a Zones object
print(number_of_zones(sim_features_zones))
# create problem with multiple zones
p <- problem(sim_pu_zones_stack, sim_features_zones) \%>\%
     add_min_set_objective() \%>\%
     add_relative_targets(matrix(0.2, ncol = 3, nrow = 5)) \%>\%
     add_binary_decisions()

# print number of zones in the problem
print(number_of_zones(p))
}
