% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.SpatialGrid.prevR.r
\name{as.SpatialGrid,prevR-method}
\alias{as.SpatialGrid,prevR-method}
\alias{as.SpatialGrid-methods}
\alias{as.SpatialGrid}
\title{Create a spatial grid from an object of class prevR.}
\usage{
\S4method{as.SpatialGrid}{prevR}(object, nb.cells = 100, cell.size = NULL)
}
\arguments{
\item{object}{object of class \linkS4class{prevR}.}

\item{nb.cells}{number of cells on the longuest side of the studied area
(unused if \code{cell.size} is defined).}

\item{cell.size}{size of each cell (in the unit of the projection).}
}
\value{
Object of class \link[sp:SpatialGrid-class]{sp::SpatialGrid}.
}
\description{
This function generates a spatial rectangular grid from the slot \code{boundary}
of an object of class \code{\linkS4class{prevR}}; function used in particular
by the methods \code{\link[=kde]{kde()}}, \code{\link[=krige]{krige()}} and \code{\link[=idw]{idw()}}.
}
\details{
This function generates a spatial rectangular grid, each cell being a square
of side \code{cell.size}. If \code{cell.size} is not defined, side of cells will be
calculated as the longuest side of the slot \code{boundary} of \code{object} divided
by \code{nb.cells}.
}
\examples{
str(as.SpatialGrid(fdhs))
str(as.SpatialGrid(fdhs, nb.cells=200))

}
\seealso{
\code{\link[sp:SpatialGrid]{sp::GridTopology()}}, \link[sp:SpatialGrid-class]{sp::SpatialGrid}.
}
\keyword{manip}
\keyword{spatial}
