% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precise_ptp.R
\name{calculate_precise_2021_clinical_ptp}
\alias{calculate_precise_2021_clinical_ptp}
\title{Calculate 2021 PRECISE Clinical PTP for obstructive CAD}
\usage{
calculate_precise_2021_clinical_ptp(
  age,
  sex,
  chest_pain_type,
  have_neck_radiation,
  have_diabetes,
  have_hypertension,
  smoking_history_type,
  have_q_waves,
  have_st_t_changes
)
}
\arguments{
\item{age}{Input integer value to indicate the age of the patient.}

\item{sex}{Input characters (female, male) to indicate the sex of the patient.
\itemize{
  \item female
  \item male
}}

\item{chest_pain_type}{Input characters (typical, atypical, nonanginal)
to indicate the chest pain characteristics of the patient.
\itemize{
  \item typical stands for the patient having typical chest pain.
  \item atypical stands for the patient having atypical chest pain.
  \item nonanginal stands for the patient having nonanginal or non-specific chest pain.
}}

\item{have_neck_radiation}{Input characters (no, yes) to indicate if the patient
has chest pain radiating to the neck.
\itemize{
  \item no stands for not chest pain radiating to the neck.
  \item yes stands for having chest pain radiating to the neck.
}}

\item{have_diabetes}{Input characters (no, yes) to indicate if the patient
has diabetes.
\itemize{
  \item no stands for not having diabetes.
  \item yes stands for having diabetes.
}}

\item{have_hypertension}{Input characters (no, yes) to indicate if the patient
has hypertension.
\itemize{
  \item no stands for not having hypertension.
  \item yes stands for having hypertension.
}}

\item{smoking_history_type}{Input characters (current, past, none) to indicate
the smoking history of the patient.
\itemize{
  \item current stands for being a current smoker.
  \item past stands for being a past smoker.
  \item none stands for not having a smoking history (non-smoker).
}}

\item{have_q_waves}{Input characters (no, yes) to indicate if the patient
has Q waves on electrocardiogram (ECG).
\itemize{
  \item no stands for the patient not having Q waves on ECG.
  \item yes stands for the patient having Q waves on ECG.
}}

\item{have_st_t_changes}{Input characters (no, yes) to indicate if the patient
has ST-T changes on electrocardiogram (ECG).
\itemize{
  \item no stands for the patient not having ST-T changes on ECG.
  \item yes stands for the patient having ST-T changes on ECG.
}}
}
\value{
A numeric value representing the patient's PTP for obstructive CAD
based on the 2021 Predictive Risk scorE for CAD In Southeast Asians
with chEst pain (PRECISE) clinical model.
}
\description{
This function returns a patient's
pre-test probability (PTP) of obstructive
coronary artery disease based on the
2021 Predictive Risk scorE for CAD In Southeast Asians with chEst pain
(PRECISE) clinical model.
}
\details{
The predictive model is based on
patients a mixed Asian cohort within Singapore with stable chest pain.
}
\examples{
# 40 year old female with typical chest pain
# radiating to the neck, has diabetes
# but no hypertension and a non-smoker.
# She has Q waves but no ST-T changes on ECG.

calculate_precise_2021_clinical_ptp(
    age = 40,
    sex = "female",
    chest_pain_type = "typical",
    have_neck_radiation = "yes",
    have_diabetes = "yes",
    have_hypertension = "no",
    smoking_history_type = "none",
    have_q_waves = "yes",
    have_st_t_changes = "no"
)
}
