% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_o2.R
\encoding{UTF-8}
\name{import_o2}
\alias{import_o2}
\title{Import data from PreSens O2 transmitter}
\usage{
import_o2(file, o2_unit = "percent_a.s.", date = "\%d/\%m/\%y",
  salinity = 35)
}
\arguments{
\item{file}{a character string. The filepath for the file to be read.}

\item{o2_unit}{a character string. The unit of O2 measurement to be output in the data.frame. Options are:\describe{
\item{percent_a.s. (percent air saturation)}{}
\item{percent_o2}{}
\item{hPa}{}
\item{kPa}{}
\item{torr}{}
\item{mmHg}{}
\item{inHg}{}
\item{mg_per_l}{}
\item{umol_per_l}{}
\item{ml_per_l}{}
}}

\item{date}{a character string. The date format to be passed to \code{\link{strptime}}.}

\item{salinity}{salinity of water sample (psu). Default is 35 psu.}
}
\value{
A data frame with seven columns is returned.
\describe{
\item{TIME}{Date and time, POSIXct format.}
\item{DURATION}{Duration of measurement trial (minutes).}
\item{oxygen}{Oxygen measurement in desired unit. Column name changes based on \code{o2_unit} argument.}
\item{PHASE}{Phase recorded. Phase is inversely related to O2.}
\item{AMPLITUDE}{Amplitude recorded. Amplitude is an indicator of the quality of the signal. A low amplitude warning is produced by the transmitter below 2500.}
\item{TEMPERATURE}{Temperature recorded or defined at beginning of measurement trial.}
\item{ERROR_CODE}{Error code from transmitter. See PreSens user manual for translation of error code.}
}
}
\description{
Imports the standard txt file output from most PreSens fiber optic O2 transmitters and converts the data into a data frame.
}
\details{
The following PreSens fiber optic O2 transmitters are supported:
\describe{
\item{Fibox 3}{}
\item{Fibox 3 trace}{}
\item{Fibox 3 LCD trace}{}
\item{Microx TX3}{}
\item{Microx TX3 trace}{}
\item{OXY-4 mini}{}
\item{OXY-4 micro}{}
\item{OXY-4 trace}{}
\item{OXY-10 mini}{}
\item{OXY-10 micro}{}
\item{OXY-10 trace}{}
}
It is very important to note that the PreSens fiber optics O2 transmitters that are supported with this function DO NOT account for salinity (i.e. they assume salinity = 0 ppt). If the water sample measured was not fresh water, the oxygen concentrations (e.g. mg per liter or umol per liter) are incorrect in the PreSens txt file. This function corrects these O2 concentrations based on the salinity value defined by the \code{salinity} argument. Absolute partial pressures (i.e. hPa and torr) will also be slightly different due to the slight influence of salinity on water's vapor pressure. This difference is typically ~0.05\% of the recorded value.
}
\note{
Conversions are estimates based on the \code{\link[marelac]{marelac}} package and therefore differ slightly from the conversions provided by PreSens.
}
\examples{
\dontrun{
file <- system.file('extdata', 'all_o2_units.txt', package = 'presens')
import_o2(file, o2_unit = 'umol_per_l', salinity = 25)
}

}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}

