% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choices.R
\name{choices}
\alias{choices}
\title{Choices Object}
\usage{
choices(preferences, names = FALSE)
}
\arguments{
\item{preferences}{a \verb{\link{preferences}} object, or an object that can be
coerced by \code{as.preferences}.}

\item{names}{logical: if \code{TRUE} use the object names in the returned
\code{"choices"} object, else use object indices.}
}
\value{
A data frame of class \code{choices} with elements:
\describe{
\item{choices}{A list where each element represents the items chosen for a
single rank in the ordering.}
\item{alternatives}{A list where each element represents the alternatives
(i.e. the set of remaining items to choose from) for a single rank.}
\item{ordering}{A list where each element represents the ordering
that the choice belongs to.}
}
The list stores the number of choices and the names of the objects as the
attributes \code{nchoices} and \code{objects} respectively.
}
\description{
Convert a set of preferences to a list of choices, alternatives, and
preferences.
}
\examples{
R <- matrix(c(
  1, 2, 0, 0,
  4, 1, 2, 3,
  2, 1, 1, 1,
  1, 2, 3, 0,
  2, 1, 1, 0,
  1, 0, 3, 2
), nrow = 6, byrow = TRUE)
colnames(R) <- c("apple", "banana", "orange", "pear")
R <- preferences(R, format = "ranking")

actual_choices <- choices(R, names = TRUE)
actual_choices[1:6, ]

coded_choices <- choices(R, names = FALSE)
coded_choices[1:2, ]
as.data.frame(coded_choices)[1:2, ]
attr(coded_choices, "objects")

}
