% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.preferences.R
\name{aggregate.preferences}
\alias{aggregate.preferences}
\alias{as.aggregated_preferences}
\alias{[.aggregated_preferences}
\alias{frequencies}
\title{Aggregate Preferences}
\usage{
\method{aggregate}{preferences}(x, frequencies = NULL, ...)

as.aggregated_preferences(x, ...)

\method{[}{aggregated_preferences}(x, i, j, ...)

frequencies(x)
}
\arguments{
\item{x}{A \code{\link{preferences}} object for \code{aggregate()}; an
object that can be coerced to an \code{aggregated_preferences} object for
\code{as.aggregated_preferences()}, otherwise an \code{aggregated_preferences}
object.}

\item{frequencies}{A vector of frequencies for preferences that have been
previously aggregated.}

\item{...}{Additional arguments, currently unused.}

\item{i}{indices specifying preferences to extract, as for \verb{\link{[}}.}

\item{j}{indices specifying items to extract, as for \verb{\link{[}}.}

\item{as.aggregated_preferences}{if \code{TRUE} create an
\code{aggregated_preferences} object from the indexed preferences Otherwise
index the underlying matrix of ranks and return in a data frame with the
corresponding frequencies.}
}
\value{
A data frame of class \code{aggregated_preferences}, with columns:
\describe{
\item{preferences}{A \code{\link{preferences}} object of the unique
preferences}
\item{frequencies}{The corresponding frequencies.}
}
Methods are available for \code{\link[=rbind]{rbind()}} and \code{\link[=as.matrix]{as.matrix()}}.
}
\description{
Aggregate \code{preferences}, returning an \code{aggregated_preferences} object of
the unique preferences and their frequencies. The frequencies can be
accessed via the function \code{frequencies()}.
}
\examples{
# create a preferences object with duplicated preferences
R <- matrix(c(
  1, 2, 0, 0,
  0, 1, 2, 3,
  2, 1, 1, 0,
  1, 2, 0, 0,
  2, 1, 1, 0,
  1, 0, 3, 2
), nrow = 6, byrow = TRUE)
colnames(R) <- c("apple", "banana", "orange", "pear")
R <- as.preferences(R, format = "ranking")

# aggregate the preferences
A <- aggregate(R)

# Or pass `aggregate = TRUE` to `as.preferences`
A <- as.preferences(R, aggregate = TRUE)

# Subsetting applies to the preferences, e.g. first two unique preferences
A[1:2]

# (partial) preferences projected to items 2-4 only
A[, 2:4]

# Project preferences onto their hightest ranking
A[, 1, by.rank = TRUE]

# convert to a matrix
as.matrix(A)
}
