% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.R
\name{pred}
\alias{pred}
\title{Predictions}
\usage{
pred(model = NULL, n.ahead = 20, tserie = NULL, predictions = NULL)
}
\arguments{
\item{model}{A \code{modl} object. Contains the trained model we want to predict with.}

\item{n.ahead}{Number of values to predict ahead of the end of the original time serie. Default value is 20. Must ve lower than 100.}

\item{tserie}{A \code{ts} object.}

\item{predictions}{A \code{ts} object.}
}
\value{
A list is returned of class \code{pred} containing:
\item{tserie}{Original time serie.}
\item{predictions}{Time serie with the predictions.}
}
\description{
Performs predictions over a trained model.
}
\details{
Predicts future values over a "modl" object which can be ARIMA or data mining, and returns
the predictions. Data mining predictions start right after the last value
contained in the training data, so they overlap with the end of the original.

The object contains only two time series: the original one
and the predictions. You can just set these series aswell.
}
\examples{
prediction <- pred(model=modl(prep(AirPassengers)),n.ahead=25)
pred(tserie=prediction$tserie, predictions=prediction$predictions)
}
\seealso{
{
\code{\link{modl}}
\code{\link{pred.arima}},
\code{\link{pred.dataMining}},
\code{\link{pred.compareModels}}
}
}
\author{
Alberto Vico Moreno
}
