% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simcont.R
\name{simcont}
\alias{simcont}
\title{Simulate data for a prediction model of a continuous outcome}
\usage{
simcont(Npat = 100)
}
\arguments{
\item{Npat}{Number of patients to simulate.}
}
\value{
The function returns a dataframe with:

x1, x2, x3, x4, x5, x6= patient covariates.

t= treatment assignment (0 for control, 1 for active).

y.control= the outcome if the patient takes the control treatment.

y.active= the outcome if the patient takes the active treatment.

benefit= the treatment benefit, i.e. y.active-y.control.

y.observed= the observed outcome.
}
\description{
This function generates a dataframe with 6 patient covariates and a continuous outcome
simulated from a model that uses the covariates.
}
\examples{
dat1=simcont(100)$dat
head(dat1)
}
