% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{predict_race}
\alias{predict_race}
\title{Find the race of a surname}
\usage{
predict_race(name, probability = TRUE)
}
\arguments{
\item{name}{String or vector of strings of surname that you want to know the race of.}

\item{probability}{If TRUE (default) will provide columns for each race with the probability
that the surname is of that race. If FALSE, will only return the name,
the match-name from the Census data, and the most likely race.}
}
\value{
A data.frame with three or nine columns: The first column has the name as inputted,
the second column has the cleaned up name (no spaces or punctuation, all
lowercase), the third column tells the likely race of the surname (if there are multiple races with the same probability of a match, it will be a string with each race separated by a comma). If the
parameter probability is false, these three columns are all that is returned.
Otherwise, columns 4-9 tell the specific probability that the surname
is each race.
}
\description{
Find the race of a surname
}
\examples{
predict_race("franklin")

predict_race(c("franklin", "Washington", "Jefferson", "Sotomayor", "Liu"))
predict_race("franklin", probability = FALSE)
}
