% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R, R/prediction_methods.R
\name{prediction}
\alias{prediction}
\alias{prediction.coxph}
\alias{prediction.default}
\alias{prediction.glm}
\alias{prediction.gls}
\alias{prediction.ivreg}
\alias{prediction.lm}
\alias{prediction.loess}
\alias{prediction.nls}
\alias{prediction.polr}
\alias{prediction.survreg}
\title{Extract Predictions from a Model Object}
\usage{
prediction(model, data, ...)

\method{prediction}{default}(model, data = find_data(model, parent.frame()),
  type = "response", ...)

\method{prediction}{lm}(model, data = find_data(model, parent.frame()),
  type = "response", ...)

\method{prediction}{glm}(model, data = find_data(model, parent.frame()),
  type = c("response", "link"), ...)

\method{prediction}{loess}(model, data = find_data(model, parent.frame()),
  type = "response", ...)

\method{prediction}{ivreg}(model, data = find_data(model, parent.frame()),
  ...)

\method{prediction}{nls}(model, data = find_data(model, parent.frame()), ...)

\method{prediction}{survreg}(model, data = find_data(model, parent.frame()),
  type = c("response", "lp", "quantile", "uquantile"), ...)

\method{prediction}{coxph}(model, data = find_data(model, parent.frame()),
  type = c("risk", "expected", "lp"), ...)

\method{prediction}{gls}(model, data, ...)

\method{prediction}{polr}(model, data = find_data(model, parent.frame()), ...)
}
\arguments{
\item{model}{A model object, perhaps returned by \code{\link[stats]{lm}} or \code{\link[stats]{glm}}.}

\item{data}{A data.frame over which to calculate marginal effects. If missing, \code{\link{find_data}} is used to specify the data frame.}

\item{type}{A character string indicating the type of marginal effects to estimate. Mostly relevant for non-linear models, where the reasonable options are \dQuote{response} (the default) or \dQuote{link} (i.e., on the scale of the linear predictor in a GLM). For models of class \dQuote{polr} (from \code{\link[MASS]{polr}}), possible values are \dQuote{class} or \dQuote{probs}; both are returned.}

\item{\dots}{Additional arguments passed to \code{\link[stats]{predict}} methods.}
}
\value{
A data.frame with class \dQuote{prediction} that has a number of rows equal to number of rows in \code{data}, where each row is an observation and the first two columns represent fitted/predicted values (\code{fitted}) and the standard errors thereof (\code{se.fitted}). Additional columns may be reported depending on the object class.
require("datasets")
x <- lm(mpg ~ cyl * hp + wt, data = mtcars)
prediction(x)
}
\description{
Extract predicted values via \code{\link[stats]{predict}} from a model object, conditional on data
}
\details{
This function is simply a wrapper around \code{\link[stats]{predict}} that returns a data frame containing predicted values with respect to all variables specified in \code{data}.

Methods are currently implemented for the following object classes:
\itemize{
  \item \dQuote{lm}, see \code{\link[stats]{lm}}
  \item \dQuote{glm}, see \code{\link[stats]{glm}}, \code{\link[MASS]{glm.nb}}
  \item \dQuote{loess}, see \code{\link[stats]{loess}}
  \item \dQuote{polr}, see \code{\link[MASS]{polr}}
  \item \dQuote{gls}, see \code{\link[nlme]{gls}}
  \item \dQuote{ivreg}, see \code{\link[AER]{ivreg}}
  \item \dQuote{nls}, see \code{\link[stats]{nls}}
  \item \dQuote{coxph}, see \code{\link[survival]{coxph}}
  \item \dQuote{survreg}, see \code{\link[survival]{survreg}}
}
}
\keyword{models}

