% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce_plot.R
\name{ce_plot}
\alias{ce_plot}
\title{Create a cost-effectiveness plot.}
\usage{
ce_plot(
  object,
  ref_col,
  wtp,
  show_wtp = TRUE,
  methods_order = NULL,
  rename_vector,
  ...
)
}
\arguments{
\item{object}{A \code{predictNMBsim} object.}

\item{ref_col}{Which cutpoint method to use as the reference strategy
when calculating the incremental net monetary benefit. Often sensible to use
a "all" or "none" approach for this.}

\item{wtp}{A \code{numeric}. The willingness to pay value used to create a
cost-effectiveness plane on the plot (if \code{show_wtp = TRUE}).}

\item{show_wtp}{A \code{logical}. Whether or not to show the willingness to
pay plane.}

\item{methods_order}{The order (within the legend) to display the
cutpoint methods.}

\item{rename_vector}{A named vector for renaming the methods in the summary.
The values of the vector are the default names and the names given are the
desired names in the output.}

\item{...}{Additional (unused) arguments.}
}
\value{
Returns a \code{ggplot} object.
}
\description{
Create a cost-effectiveness plot.
}
\details{
This plot method works with \code{predictNMBsim} objects that are created
using \code{do_nmb_sim()}. Can be used to visualise the simulations on a
cost-effectiveness plot (costs vs effectiveness)
}
\examples{
\donttest{
get_nmb_evaluation <- get_nmb_sampler(
  qalys_lost = function() rnorm(1, 0.33, 0.03),
  wtp = 28000,
  high_risk_group_treatment_effect = function() exp(rnorm(n = 1, mean = log(0.58), sd = 0.43)),
  high_risk_group_treatment_cost = function() rnorm(n = 1, mean = 161, sd = 49)
)

sim_obj <- do_nmb_sim(
  sample_size = 200, n_sims = 50, n_valid = 10000, sim_auc = 0.7,
  event_rate = 0.1, fx_nmb_training = get_nmb_evaluation, fx_nmb_evaluation = get_nmb_evaluation
)

ce_plot(sim_obj, ref_col = "all")
}
}
