% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infergen.R
\name{infergen}
\alias{infergen}
\title{Infer Genotype of Hybrids}
\usage{
infergen(inbred_gen, hybrid_phe)
}
\arguments{
\item{inbred_gen}{a matrix for genotypes of parental lines in numeric format, coded as 1, 0 and -1. The row.names of inbred_gen must be provied. It can be obtained from the original genotype using \code{\link{convertgen}} function.}

\item{hybrid_phe}{a data frame with three columns. The first column and the second column are the names of male and female parents of the corresponding hybrids, respectively; the third column is the phenotypic values of hybrids.
The names of male and female parents must match the rownames of inbred_gen. Missing (NA) values are not allowed.}
}
\value{
A list with following information is returned:

    $add  additive genotypes of hybrids

    $dom  dominance genotypes of hybrids
}
\description{
Infer additive and dominance genotypes of hybrids based on their parental genotypes.
}
\examples{

## load example data from hypred package
data(hybrid_phe)
head(hybrid_phe)
data(input_geno)

## convert original genotype
inbred_gen <- convertgen(input_geno, type = "hmp2")

gena <- infergen(inbred_gen, hybrid_phe)$add
gend <- infergen(inbred_gen, hybrid_phe)$dom

}
