% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enhance.R
\name{cohorts_of_n}
\alias{cohorts_of_n}
\title{Override \code{escalation::cohorts_of_n} to include latent toxicity tolerances}
\usage{
cohorts_of_n(n = 3, mean_time_delta = 1)
}
\arguments{
\item{n}{integer, sample arrival times for this many patients.}

\item{mean_time_delta}{the average gap between patient arrival times. I.e.
the reciprocal of the rate parameter in an Exponential distribution.}
}
\value{
\code{data.frame} with columns \code{u_i} and \code{time_delta}
containing respectively the uniformly-distributed latent toxicity tolerance
and arrival-time increment for each trial participant.
}
\description{
The original function in package \code{escalation} recognizes that individual
trial participants arrive at distinct times. Building upon this acknowledgment
of individuality, this override adds an extra line of code to draw as well a
latent toxicity tolerance \code{u_i} for each individual participant.
}
\examples{
cohorts_of_n()
cohorts_of_n(n = 10, mean_time_delta = 5)
}
\seealso{
\code{\link[=phase1_sim]{phase1_sim()}}, which this package also overrides with similarly
minute changes in order to incorporate \code{u_i}.
}
