% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{importance.pre}
\alias{importance.pre}
\alias{importance}
\title{Calculate importances of baselearners and input variables in a prediction 
rule ensemble (pre)}
\usage{
\method{importance}{pre}(
  x,
  standardize = FALSE,
  global = TRUE,
  penalty.par.val = "lambda.1se",
  gamma = NULL,
  quantprobs = c(0.75, 1),
  round = NA,
  plot = TRUE,
  ylab = "Importance",
  main = "Variable importances",
  abbreviate = 10L,
  diag.xlab = TRUE,
  diag.xlab.hor = 0,
  diag.xlab.vert = 2,
  cex.axis = 1,
  legend = "topright",
  ...
)
}
\arguments{
\item{x}{an object of class \code{\link{pre}}}

\item{standardize}{logical. Should baselearner importances be standardized 
with respect to the outcome variable? If \code{TRUE}, baselearner importances 
have a minimum of 0 and a maximum of 1. Only used for ensembles with 
numeric (non-count) response variables.}

\item{global}{logical. Should global importances be calculated? If 
\code{FALSE}, local importances will be calculated, given the quantiles 
of the predictions F(x) in \code{quantprobs}.}

\item{penalty.par.val}{character or numeric. Value of the penalty parameter
\eqn{\lambda} to be employed for selecting the final ensemble. The default
\code{"lambda.min"} employs the \eqn{\lambda} value within 1 standard
error of the minimum cross-validated error. Alternatively, 
\code{"lambda.min"} may be specified, to employ the \eqn{\lambda} value
with minimum cross-validated error, or a numeric value \eqn{>0} may be 
specified, with higher values yielding a sparser ensemble. To evaluate the 
trade-off between accuracy and sparsity of the final ensemble, inspect
\code{pre_object$glmnet.fit} and \code{plot(pre_object$glmnet.fit)}.}

\item{gamma}{Mixing parameter for relaxed fits. See
\code{\link[glmnet]{coef.cv.glmnet}}.}

\item{quantprobs}{optional numeric vector of length two. Only used when
\code{global = FALSE}. Probabilities for calculating sample quantiles of the 
range of F(X), over which local importances are calculated. The default 
provides variable importances calculated over the 25\% highest values of F(X).}

\item{round}{integer. Number of decimal places to round numeric results to.
If \code{NA} (default), no rounding is performed.}

\item{plot}{logical. Should variable importances be plotted?}

\item{ylab}{character string. Plotting label for y-axis. Only used when
\code{plot = TRUE}.}

\item{main}{character string. Main title of the plot. Only used when
\code{plot = TRUE}.}

\item{abbreviate}{integer or logical. Number of characters to abbreviate 
x axis names to. If \code{FALSE}, no abbreviation is performed.}

\item{diag.xlab}{logical. Should variable names be printed diagonally (that
is, in a 45 degree angle)? Alternatively, variable names may be printed 
vertically by specifying \code{diag.xlab = FALSE} and \code{las = 2}.}

\item{diag.xlab.hor}{numeric. Horizontal adjustment for lining up variable
names with bars in the plot if variable names are printed diagonally.}

\item{diag.xlab.vert}{positive integer. Vertical adjustment for position
of variable names, if printed diagonally. Corresponds to the number of 
character spaces added after variable names.}

\item{cex.axis}{numeric. The magnification to be used for axis annotation
relative to the current setting of \code{cex}.}

\item{legend}{logical or character. Should legend be plotted for multinomial
or multivariate responses and if so, where? Defaults to \code{"topright"}, 
which puts the legend in the top-right corner of the plot. Alternatively, 
\code{"bottomright"}, \code{"bottom"}, \code{"bottomleft"}, \code{"left"}, 
\code{"topleft"}, \code{"top"}, \code{"topright"}, \code{"right"}, 
\code{"center"} and \code{FALSE} (which omits the legend) can be specified.}

\item{...}{further arguments to be passed to \code{barplot} (only used
when \code{plot = TRUE}).}
}
\value{
A list with two dataframes: \code{$baseimps}, giving the importances 
for baselearners in the ensemble, and \code{$varimps}, giving the importances 
for all predictor variables.
}
\description{
\code{importance.pre} calculates importances for rules, linear terms and input
variables in the prediction rule ensemble (pre), and creates a bar plot 
of variable importances.
}
\details{
See also sections 6 and 7 of Friedman & Popecus (2008).
}
\examples{
\donttest{set.seed(42)
airq.ens <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),])
# calculate global importances:
importance(airq.ens)
# calculate local importances (default: over 25\% highest predicted values):
importance(airq.ens, global = FALSE)
# calculate local importances (custom: over 25\% lowest predicted values):
importance(airq.ens, global = FALSE, quantprobs = c(0, .25))}
}
\references{
Fokkema, M. (2020). Fitting prediction rule ensembles with R 
package pre. \emph{Journal of Statistical Software, 92}(12), 1-30.
\doi{10.18637/jss.v092.i12}

Fokkema, M. & Strobl, C. (2020). Fitting prediction rule ensembles to psychological 
research data: An introduction and tutorial. \emph{Psychological Methods 25}(5), 
636-652. \doi{10.1037/met0000256}, \url{https://arxiv.org/abs/1907.05302}

Friedman, J. H., & Popescu, B. E. (2008). Predictive learning 
via rule ensembles. \emph{The Annals of Applied Statistics, 2}(3), 916-954 
\doi{10.1214/07-AOAS148}.
}
\seealso{
\code{\link{pre}}
}
