% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpe_miscs.R
\name{coef.gpe}
\alias{coef.gpe}
\title{Coefficients for a General Prediction Ensemble (gpe)}
\usage{
\method{coef}{gpe}(object, penalty.par.val = "lambda.1se", ...)
}
\arguments{
\item{object}{object of class \code{\link{pre}}}

\item{penalty.par.val}{character or numeric. Value of the penalty parameter
\eqn{\lambda} to be employed for selecting the final ensemble. The default
\code{"lambda.min"} employs the \eqn{\lambda} value within 1 standard
error of the minimum cross-validated error. Alternatively, 
\code{"lambda.min"} may be specified, to employ the \eqn{\lambda} value
with minimum cross-validated error, or a numeric value \eqn{>0} may be 
specified, with higher values yielding a sparser ensemble. To evaluate the 
trade-off between accuracy and sparsity of the final ensemble, inspect
\code{pre_object$glmnet.fit} and \code{plot(pre_object$glmnet.fit)}.}

\item{...}{additional arguments to be passed to \code{\link[glmnet]{coef.cv.glmnet}}.}
}
\description{
coef function for \code{\link{gpe}}
}
\seealso{
\code{\link{coef.pre}}
}
