% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{cvpre}
\alias{cvpre}
\title{Full k-fold cross validation of a pre}
\usage{
cvpre(object, k = 10, seed = 42, verbose = TRUE, pclass = 0.5)
}
\arguments{
\item{object}{An object of class \code{\link{pre}}.}

\item{k}{integer. The number of cross validation folds to be used.}

\item{seed}{integer. Random seed to be used for generating 
cross-validation subsamples.}

\item{verbose}{logical. Should progress of the cross validation be printed 
to the command line?}

\item{pclass}{numeric. Only used for classification. Cut-off value between 
0 and 1 to be used for classifying to second class.}
}
\value{
A list with three elements: cvpreds (a vector with cross-validated
predicted y values), ss (a vector indicating the cross-validation subsample 
each training observation was assigned to) and accuracy. For continuous 
outputs, accuracy is a list with elements MSE (mean squared error on test 
observations), MAE (mean absolute error on test observations) and 
cor_true_pred_y, which is the correlation between the actual and predicted 
outcome variable values. For classification, accuracy is a list with elements 
SEL (mean squared error on predicted probabilities), AEL (mean absolute 
error on predicted probabilities), MCR (average misclassification error rate) 
and table (a table with proportions of (in)correctly classified observations 
per class).
}
\description{
\code{cvpre} performs k-fold cross validation on the dataset used to create 
the ensemble, providing an estimate of predictive accuracy on future observations.
}
\examples{
\donttest{
airq.ens <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),])
airq.cv <- cvpre(airq.ens)}
}

