% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_zzz.R
\docType{class}
\name{ToolIFBase}
\alias{ToolIFBase}
\title{Base class of performance evaluation tools}
\format{An R6 class object}
\usage{
ToolIFBase
}
\description{
\code{ToolIFBase} is an abstract class to provide a uniform interface for
performance evaluation tools.
}
\section{Methods}{

\itemize{
 \item \code{call(testset, calc_auc, store_res)}: It calls an actual
     tool to calculate Precision-Recall curves.
     \describe{
       \item{\code{testset}}{\code{R6} object generated by the
                              \code{create_testset} function.}
       \item{\code{calc_auc}}{A Boolean value to specify whether the AUC
                              score should be calculated.}
       \item{\code{store_res}}{A Boolean value to specify whether the
                               calculated curve is retrieved and stored.}
      }
 \item \code{get_toolname()}: Get the name of the tool.
 \item \code{set_toolname(toolname)}: Set the name of the tool.
 \item \code{get_setname()}: Get the name of the tool set.
 \item \code{set_setname(setname)}: Set the name of the tool set.
 \item \code{get_result()}: Get a list with curve values and the AUC score.
 \item \code{get_x()}: Get calculated recall values.
 \item \code{get_y()}: Get calculated precision values.
 \item \code{get_auc()}: Get tne AUC score.
}.
}
\seealso{
\code{\link{ToolROCR}}, \code{\link{ToolAUCCalculator}},
  \code{\link{ToolPerfMeas}}, \code{\link{ToolPRROC}},
  and \code{\link{Toolprecrec}} are derived from this class.
  \code{\link{create_toolset}} for creating a list of tools.
}
\keyword{datasets}

