\name{crmatrix}
\alias{crmatrix}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Region-wise cluster membership}
\description{
  Produces a matrix with clusters as rows and regions as columns,
  indicating how many species present in a region belong to the clusters
}
\usage{
crmatrix(x,xc,percentages=FALSE)

}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{object of class \code{prab} as
    generated by \code{prabinit}. Presence-absence data to be analyzed.}
  \item{xc}{object of class \code{prabclust} or \code{comprabclust}
    as generated by \code{prabclust} or \code{hprabclust}. The
    clustering.}
  \item{percentages}{logical. If \code{TRUE}, the output matrix will
    give the proportion of species from a certain region in the cluster.}
}

\value{
  A clusters time regions matrix as explained above.
}
\author{Christian Hennig
  \email{chrish@stats.ucl.ac.uk}
  \url{http://www.homepages.ucl.ac.uk/~ucakche}
}

\examples{
  data(kykladspecreg)
  data(nb)
  set.seed(1234)
  x <- prabinit(prabmatrix=kykladspecreg, neighborhood=nb)
  xc <- prabclust(x)

  crmatrix(x,xc)
  crmatrix(x,xc, percentages=TRUE)

}

\keyword{spatial}% at least one, from doc/KEYWORDS
\keyword{cluster}% __ONLY ONE__ keyword per line
