% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{statistics}
\alias{statistics}
\title{Compute statistics}
\usage{
statistics(data, n, K, directed = TRUE)
}
\arguments{
\item{data}{List with $type.seq, $time.seq}

\item{n}{Total number of nodes : \eqn{i,j\in {1, \ldots, n} }}

\item{K}{Size of the regular partition, i.e. number of subintervals}

\item{directed}{Boolean for directed (TRUE) or undirected (FALSE) case}
}
\value{
N(i,j)k = number of events for the node (i,j) during the k-th subinterval
}
\description{
Convert the initial data into the statistics matrix \eqn{N_{ijk}}, by counting the number of events for the nodes during the subintervals of a particular partition of the time interval.
}
\examples{
# Convert the generated data into the statistics matrix N_ijk with 8 columns

n <- 50
Dmax <- 2^3

obs <- statistics(generated_Q3$data,n,Dmax,directed=FALSE)

}
