% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiMWI2015}
\alias{ppiMWI2015}
\title{ppiMWI2015}
\format{A data frame with 3 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
}}
\source{
\url{www.povertyindex.org}
}
\usage{
ppiMWI2015
}
\description{
Poverty Probability Index (PPI) lookup table for Malawi using legacy
poverty definitions
}
\examples{
  # Access Malawi PPI table
  ppiMWI2015

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiMWI2015[ppiMWI2015$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiMWI2015, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, below $1.25
  # purchasing power parity (2005)
  ppiScore <- 50
  ppiMWI2015[ppiMWI2015$score == ppiScore, "ppp125"]

}
\keyword{datasets}
