% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppgmMESS.R
\name{ppgmMESS}
\alias{ppgmMESS}
\title{ppgmMESS}
\usage{
ppgmMESS(cem_min, cem_max, est, tree, fossils=NULL, timeslice, 
which.biovars, path = "", use.paleoclimate=TRUE, paleoclimateUser = NULL, 
layerAge=c(0:20), which.plot = c("all","mess","none"))
}
\arguments{
\item{cem_min}{the cem min output from the ppgm function. cbind() if there are multiple variables.}

\item{cem_max}{the cem max output from the ppgm function. cbind() if there are multiple variables.}

\item{est}{the node_est output from the ppgm function, in list format. [tree][1][min and max][no.of species]}

\item{tree}{the phylogeny or multiple phylogenies that show the relationship between species}

\item{fossils}{a matrix with four columns of age to the closest million year integer, longitude, and latitude, in that order, and rows that are entries for fossil occurrences.}

\item{timeslice}{the time in million of years ago to project MESS maps (0 to 20). can handle single timeslice or vector of times.}

\item{which.biovars}{the biovariable number(s) between 1 and 19.}

\item{path}{directory where plots should be stored}

\item{use.paleoclimate}{if left blank, default North America paleoclimate data is used. If FALSE, user submitted paleoclimate must be provided}

\item{paleoclimateUser}{list of data frames with paleoclimates, must be dataframes with columns: GlobalID, Longitude, Latitude, bio1, bio2,...,bio19.}

\item{layerAge}{vector with the ages of the paleoclimate dataframes, if using user submitted paleoclimate data}

\item{which.plot}{"all" plots trait maps and MESS, "mess" plots MESS map, "none" does not plot}
}
\value{
list containing array of MESS scores for bioclimatic variables
}
\description{
This creates a MESS map for given time slices, climate envelopes, and paleoclimate models.
}
\details{
plots MESS maps of climate envelope model for specific time slices. Can either plot individual biovariables, or combined.
}
\examples{
data(sampletrees)
data(occurrences)
sampletrees <- sample(sampletrees,5)
bounds <- list(sigsq = c(min = 0, max = 1000000))
\donttest{test_ppgm <- ppgm(occurrences = occurrences,trees = sampletrees, 
model = "BM", which.biovars = c(1,4,15), bounds = bounds, 
control = list(niter = 20))
#extract min climate envelope for species
cem_min <- cbind(test_ppgm$cem[, 1], test_ppgm$cem[, 2], test_ppgm$cem[, 3])
cem_max <- cbind(test_ppgm$cem[, 7], test_ppgm$cem[, 8], test_ppgm$cem[, 9])
rownames(cem_min) <- rownames(cem_max) <- rownames(test_ppgm$cem)
mess <- ppgmMESS(cem_min,cem_max,test_ppgm$node_est,tree=sampletrees,timeslice=10,
which.biovars=c(1,4,15), path=tempdir(), which.plot="none")}
}
\seealso{
\code{ppgm()}
}
\author{
A. Michelle Lawing, Alexandra F. C. Howard, Maria-Aleja Hurtado-Materon
}
