% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop.paired.R
\name{prop.paired}
\alias{prop.paired}
\title{Power calculation for McNemar test of two correlated proportions}
\usage{
prop.paired(
  N = NULL,
  p1 = NULL,
  p2 = NULL,
  phi = NULL,
  paid = NULL,
  dpr = NULL,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{N}{The sample size; the number of pairs.}

\item{p1}{The outcome proportion under condition 1.}

\item{p2}{The outcome proportion under condition 2.}

\item{phi}{The correlation between the two responses from an individual.}

\item{paid}{The smaller of the two discordant probabilities. Either p1, p2 and phi, OR paid and dpr must be specified.}

\item{dpr}{The discordant proportion ratio. Must be greater than or equal to 1. Either p1, p2, and phi, OR paid and dpr must be specified.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Performs power and sample size calculation for McNemar test of two correlated
proportions using normal approximation. Can solve for power, N or alpha.
}
\details{
Either p1, p2 and phi, OR paid and dpr must be specified.
}
\examples{
prop.paired(N = NULL, p1 = 0.8, p2 = 0.9, phi = 0, power = 0.9, sides = 2)
prop.paired(N = NULL, paid = 0.08, dpr = 0.18 / 0.08, power = 0.9, sides = 2)
}
