% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_ntail.R
\name{get_ntail}
\alias{get_ntail}
\title{Values greater than or equal to xmin}
\usage{
get_ntail(m, prop = FALSE, lower = FALSE)
}
\arguments{
\item{m}{a distribution object.}

\item{prop}{default \code{FALSE}. Return the value as a proportion of the total sample size}

\item{lower}{default \code{FALSE}. If \code{TRUE} returns sample size  - ntail}
}
\description{
Returns the number of data points greater than or equal to
current value of xmin. In the Clauset et al, paper this is
called `ntail`.
}
\examples{
################################################
# Load data and create example object
################################################
data(moby_sample)
m = displ$new(moby_sample)
m$setXmin(7)
################################################
# Get ntail
################################################
get_ntail(m)
sum(moby_sample >= 7)
}

