% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.XY}
\alias{plot.XY}
\title{Plotting an XY object}
\usage{
\method{plot}{XY}(x, wavelength, xlim, normalise, interactive, ...)
}
\arguments{
\item{x}{an XY object}

\item{wavelength}{One of "Cu", "Co" or a custom numeric value defining the wavelength
(in Angstroms). Used to compute d-spacings.When "Cu" or "Co" are supplied, wavelengths
of 1.54056 or 1.78897 are used, respectively.}

\item{xlim}{A numeric vector providing limits of the x-axis (E.g. \code{c(10, 60)}).
Defaults to full x-axis unless specified.}

\item{normalise}{Logical. If TRUE then count intensities will be normalised to a
minimum of zero and maximum of 1. Default \code{= FALSE}.}

\item{interactive}{Logical. If TRUE then the output will be an interactive
ggplotly object. If FALSE then the output will be a ggplot object.}

\item{...}{other arguments}
}
\description{
\code{plot.XY} is designed to provide easy, adaptable plots
of an XRPD pattern.
}
\details{
Plots can be made interactive using the logical \code{interactive} argument.
}
\examples{
# Load the minerals library
data(rockjock_mixtures)
\dontrun{
plot(rockjock_mixtures$Mix1, wavelength = "Cu")
plot(rockjock_mixtures$Mix1, wavelength = "Cu", interactive = TRUE)
}
}
