% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_xy.R
\name{extract_xy}
\alias{extract_xy}
\title{Import and extract XY data from proprietary files}
\usage{
extract_xy(files)
}
\arguments{
\item{files}{path of the file(s) to be imported.}
}
\value{
If only one path is supplied then an XY data frame with 2 columns is returned,
the first being the 2theta axis and the second being the count intensities. If more
than one path is supplied then a multiXY list is returned, with each item in the list being
an XY data frame as already described.
}
\description{
\code{extract_xy} is a wrapper for \code{read_xyData} of the \code{rxylib} package,
which extracts the xy data from various proprietary formats of X-ray powder
diffraction data using the \code{xylib} C++ library. For more information see
\code{?rxylib} and \code{?rxylib::read_xyData}.
}
\examples{
#load example RAW file
file <- system.file("extdata/D5000/RAW/D5000_1.RAW", package = "powdR")
raw1 <- extract_xy(file)

#Load multiple RAW files
files <- dir(system.file("extdata/D5000/RAW", package = "powdR"),
             full.names = TRUE)
raw_list <- extract_xy(files)

class(raw_list)

\dontrun{
plot(raw_list, wavelength = "Cu")
plot(raw_list, wavelength = "Cu", interactive = TRUE)
}

}
