% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_multi_xy.R
\name{as_multi_xy.data.frame}
\alias{as_multi_xy.data.frame}
\title{Create a multiXY object from a list of XRPD data}
\usage{
\method{as_multi_xy}{data.frame}(x, ...)
}
\arguments{
\item{x}{a data frame of XRPD data, with the first column as the 2theta
axis and subsequent columns of count intensities.}

\item{...}{other arguments}
}
\value{
a \code{multiXY} object.
}
\description{
\code{as_multi_xy.data.frame} takes a data frame of XRPD data from multiple
samples and ensures that it meets various requirements to create a multiXY object.
Once a \code{multiXY} object has been created, it can easily be plotted using
the associated \code{plot.multiXY} method.
}
\examples{
#load the soils data
data(soils)

#Convert to data frame
soils_df <- multi_xy_to_df(soils,
                           tth = TRUE)

#Convert back to multiXY object
soils2 <- as_multi_xy(soils_df)

}
