% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_multi_xy.R
\name{as_multi_xy}
\alias{as_multi_xy}
\title{Create a multiXY object}
\usage{
as_multi_xy(x, ...)
}
\arguments{
\item{x}{a list or data frame of XRPD data}

\item{...}{other arguments}
}
\value{
a \code{multiXY} object.
}
\description{
\code{as_multi_xy} takes a list or data frame of XRPD data and ensures
that the data meet various requirements to create a multiXY object.
Once a multiXY object has been created, it can easily be plotted using
the associated \code{plot.multiXY} method.
}
\examples{

#EXAMPLE 1

#load soils data
data(soils)

#extract first two samples from the list
soils <- soils[c(1:2)]

#convert to multiXY
soils <- as_multi_xy(soils)

#EXAMPLE 2
#load the soils data
data(soils)

#Convert to data frame
soils_df <- multi_xy_to_df(soils,
                           tth = TRUE)

#Convert back to multiXY object
soils2 <- as_multi_xy(soils_df)
}
