% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_xy.R
\name{align_xy.multiXY}
\alias{align_xy.multiXY}
\title{Align XRPD data in a multiXY object to a given standard}
\usage{
\method{align_xy}{multiXY}(x, std, xmin, xmax, xshift, ...)
}
\arguments{
\item{x}{a \code{multiXY} object.}

\item{std}{a dataframe of the chosen standard that each
sample will be aligned to (column 1 = 2theta, column 2 = counts)}

\item{xmin}{the minimum 2theta value used during alignment}

\item{xmax}{the maximum 2theta value used during alignment}

\item{xshift}{the maximum (positive and negative) 2theta shift
that is allowed during alignment}

\item{...}{other arguments}
}
\value{
a \code{multiXY} object.
}
\description{
\code{align_xy.multiXY} takes a multiXY object and aligns
each of the XY data frames within it to a given standard.
An optimisation routine is used that computes a suitable
linear shift. After all samples have been aligned,
the function harmonises the data to a single 2theta scale.
}
\examples{
# Load soils xrd data
data(soils)

#Load minerals library
data(minerals)

\dontrun{
#Create a standard quartz pattern to align to
quartz <- data.frame(tth = minerals$tth,
                     counts = minerals$xrd$QUA.1)

#Plot the main quartz peak prior to alignment
plot(soils, wavelength = "Cu",
     xlim = c(26,27),
     normalise = TRUE)

#align data
aligned <- align_xy(soils,
                    std = quartz,
                    xmin = 10,
                    xmax = 60,
                    xshift = 0.2)

#replot data
plot(aligned, wavelength = "Cu",
     xlim = c(26,27),
     normalise = TRUE)

}

}
