% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fps.R
\name{fps.powdRlib}
\alias{fps.powdRlib}
\title{Full pattern summation}
\usage{
\method{fps}{powdRlib}(lib, smpl, refs, std, tth_align, align, tth_fps,
  solver, obj, ...)
}
\arguments{
\item{lib}{A \code{powdRlib} object representing the reference library. Created using the
\code{powdRlib} constructor function.}

\item{smpl}{A data frame. First column is 2theta, second column is counts}

\item{refs}{A character string of reference pattern ID's from the specified library.
The ID's must match ID's in the \code{lib$phases$phase_id} column.}

\item{std}{The phase ID (e.g. "QUA.1") to be used as internal
standard. Must match an ID provided in the \code{phases} parameter.}

\item{tth_align}{A vector defining the minimum and maximum 2theta values to be used during
alignment. If not defined, then the full range is used.}

\item{align}{The maximum shift that is allowed during initial 2theta
alignment (degrees). Default = 0.1.}

\item{tth_fps}{A vector defining the minimum and maximum 2theta values to be used during
full pattern summation. If not defined, then the full range is used.}

\item{solver}{The optimisation routine to be used. One of \code{c("BFGS", "Nelder-Mead",
"CG")}. Default = "BFGS".}

\item{obj}{The objective function to minimise. One of \code{c("Delta", "R", "Rwp")}.
Default = \code{"Rwp"}. See Chipera and Bish (2002) and page 247 of Bish and Post (1989)
for definitions of these functions.}

\item{...}{other arguments}
}
\value{
a list with components:
\item{tth}{a vector of the 2theta scale of the fitted data}
\item{fitted}{a vector of the fitted XRPD pattern}
\item{measured}{a vector of the original XRPD measurement (aligned)}
\item{residuals}{a vector of the residuals (fitted vs measured)}
\item{phases}{a dataframe of the phases used to produce the fitted pattern}
\item{phases_summary}{the phases dataframe grouped by phase_name and summarised (sum)}
\item{rwp}{the Rwp of the fitted vs measured pattern}
\item{weighted_pure_patterns}{a dataframe of reference patterns used to produce the fitted pattern.
All patterns have been weighted according to the coefficients used in the fit}
\item{coefficients}{a named vector of coefficients used to produce the fitted pattern}
}
\description{
\code{fps.powdRlib} returns estimates of phase concentrations using full pattern
summation of X-ray powder diffraction data.
}
\details{
Applies full pattern summation (Chipera & Bish, 2002, 2013; Eberl, 2003) to an XRPD
sample to quantify phase concentrations. Requires a \code{powdRlib} library of reference
patterns with pre-measured reference intensity ratios in order to derive mineral
concentrations.
}
\examples{
#Load the minerals library
data(minerals)

# Load the soils data
data(soils)

#Since the reference library is relatively small,
#the whole library can be used at once to get an
#estimate of the phases within each sample.
\dontrun{
fps_sand <-  fps(lib = minerals,
                 smpl = soils$sandstone,
                 refs = minerals$phases$phase_id,
                 std = "QUA.1",
                 align = 0.2)

fps_lime <- fps(lib = minerals,
                smpl = soils$limestone,
                refs = minerals$phases$phase_id,
                std = "QUA.1",
                align = 0.2)

fps_granite <- fps(lib = minerals,
                   smpl = soils$granite,
                   refs = minerals$phases$phase_id,
                   std = "QUA.1",
                   align = 0.2)
}
}
\references{
Bish, D.L., Post, J.E., 1989. Modern powder diffraction. Mineralogical Society of America.

Chipera, S.J., Bish, D.L., 2013. Fitting Full X-Ray Diffraction Patterns for Quantitative Analysis:
A Method for Readily Quantifying Crystalline and Disordered Phases. Adv. Mater. Phys. Chem. 03, 47-53.
doi:10.4236/ampc.2013.31A007

Chipera, S.J., Bish, D.L., 2002. FULLPAT: A full-pattern quantitative analysis program for X-ray powder
diffraction using measured and calculated patterns. J. Appl. Crystallogr. 35, 744-749.
doi:10.1107/S0021889802017405

Eberl, D.D., 2003. User's guide to ROCKJOCK - A program for determining quantitative mineralogy from
powder X-ray diffraction data. Boulder, CA.
}
