% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equipotential.R
\name{equipotential}
\alias{equipotential}
\title{Create Polygons of Equipotential}
\usage{
equipotential(x, var, nclass = 8, breaks, mask, buffer, xcoords, ycoords)
}
\arguments{
\item{x}{an sf object of regularly spaced points. It must contain "X", "Y"
and "OUTPUT" fields.}

\item{var}{name of the OUTPUT field in \code{x}.}

\item{nclass}{a number of class.}

\item{breaks}{a vector of break values.}

\item{mask}{an sf object of polygons or multipolygons. /code{mask} is  used
to clip polygons of contours equipotential.}

\item{buffer}{if set, a buffer is internaly added to the mask in order to 
reach more precisely the number of breaks. The buffer is defined in 
\code{x} units.}

\item{xcoords}{name of the X coordinates field in \code{x}, not needed 
if \code{x} is constructed with create_grid.}

\item{ycoords}{name of the Y coordinates field in \code{x}, not needed 
if \code{x} is constructed with create_grid.}
}
\value{
The output is an sf object (POLYGONS). The data frame contains four
fields: id (id of each polygon), min and max (minimum and maximum breaks of
the polygon) and center (central values of classes).
}
\description{
This function creates polygons of equipotential from a regular grid of
potential points.
}
\examples{
library(sf)
y <- create_grid(x = n3_poly, res = 200000)
d <- create_matrix(n3_pt, y)
pot <- potential(
  x = n3_pt, y = y, d = d, var = "POP19",
  fun = "e", span = 200000, beta = 2
)
y$OUTPUT <- pot
equipot <- equipotential(y, var = "OUTPUT", mask = n3_poly)
plot(equipot["center"], pal = hcl.colors(nrow(equipot), "cividis"))
}
