% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtestSummary.R
\name{backtestSelector}
\alias{backtestSelector}
\title{Selector of portfolio backtest results}
\usage{
backtestSelector(
  bt,
  portfolio_index = NULL,
  portfolio_name = NULL,
  measures = NULL
)
}
\arguments{
\item{bt}{Backtest results as produced by the function \code{\link{portfolioBacktest}}.}

\item{portfolio_index}{Index number of a portfolio, e.g., \code{1} means to select the performance 
of the first portfolio recorded in \code{bt}.}

\item{portfolio_name}{String name of a portfolio, e.g., \code{"GMVP"} means to select the performance 
of portfolio with name \code{"GMVP"} in \code{bt}. 
Only considered when \code{portfolio_index} is not passed.}

\item{measures}{String vector to select performane measures (default is all) from
\code{"Sharpe ratio"}, \code{"max drawdown"}, \code{"annual return"}, \code{"annual volatility"}, 
\code{"Sterling ratio"}, \code{"Omega ratio"}, and \code{"ROT bps"}.}
}
\value{
List with the following elements:
\item{\code{performance}}{Performance measures selected by argument \code{measures}.}
\item{\code{error}}{Error status (\code{TRUE} or \code{FALSE}) of portfolio over each dataset
                   (\code{TRUE} is when the portfolio function generates an error or the maximum CPU time is exceeded).}
\item{\code{error_message}}{Error messages generated by portfolio function over each dataset.
                            Useful for debugging purposes.}
\item{\code{cpu time}}{CPU usage by portfolio function over each dataset.}
\item{\code{portfolio}}{Portfolio weights generated by portfolio function over each dataset.}
\item{\code{return}}{Portfolio returns over each dataset.}
\item{\code{wealth}}{Portfolio wealth (aka cumulative returns or cumulative P&L) over each dataset.}
}
\description{
Select the results from a portfolio backtest.
}
\examples{
\donttest{
library(portfolioBacktest)
data("dataset10")  # load dataset

# define your own portfolio function
uniform_portfolio <- function(dataset) {
  N <- ncol(dataset$adjusted)
  return(rep(1/N, N))
}

# do backtest
bt <- portfolioBacktest(list("Uniform" = uniform_portfolio), dataset10)

# extract your interested portfolio result
bt_sel <- backtestSelector(bt, portfolio_name = "Uniform")
names(bt_sel)
}

}
\author{
Rui Zhou and Daniel P. Palomar
}
